jQuery(function($) {

    $("#societe").select2({
        placeholder: "Rechercher une société",
        minimumInputLength: 1,
        ajax: {
            url: base_url + "admin/societes/get_list_xhr",
            dataType: 'json',
            data: function (term, page) {
                return {
                    q: term,
                    page_limit: 10
                };
            },
            results: function (data, page) {
                return {
                    results: data.results
                };
            }
        },
        initSelection: function (element, callback) {
            var data = {id: element.val(), text: element.data('initial-value')};
            callback(data);
        }
    });

    $('#id_pays, #id_groupe').select2();

    $('#contact-edit-form').submit(function(e) {
        if (!$('#email').val()) {
            if (!confirm("Le champ Email est vide.\nEtes-vous sûr de vouloir enregistrer ce contact sans email ?")) {
                e.preventDefault();
                $('#email').focus();
            }
        }
    });

    if (contact_id == "0") {
        $('#societe').change(function() {
            var id_societe = $(this).val();
            $.ajax({
                url: base_url + 'admin/societes/get_info',
                type: 'GET',
                dataType: 'json',
                data: {
                    id_societe: id_societe
                },
                success: function(societe) {
                    $('#adresse1').val(societe.adresse1);
                    $('#adresse2').val(societe.adresse2);
                    $('#adresse3').val(societe.adresse3);
                    $('#cp').val(societe.cp);
                    $('#ville').val(societe.ville);
                    $('#id_pays').select2('val', societe.id_pays);
                }
            });
        });
    }

    if ($.datepicker) {
        $('.date-picker').datepicker({
            autoclose: true,
            format: 'yyyy-mm-dd',
            language: 'fr'
        });
    }

    $('#npai, #desinscrit').change(function() {
        if ($(this).is(':checked')) {
            $(this).closest('.input-group').find('.date-picker').removeAttr('disabled').focus();
        } else {
            $(this).closest('.input-group').find('.date-picker').attr('disabled', 'disabled');
        }
    });

});