jQuery(function($) {

    $('#contacts-table').dataTable({
        "bProcessing": true,
        "bServerSide": true,
        "sAjaxSource": base_url + "admin/contacts/get_data",
        "aLengthMenu": [
            [25, 50, 100, -1],
            [25, 50, 100, "Tous"] // change per page values here
        ],
        "iDisplayLength": 25,
        "sPaginationType": "bootstrap",
        "aoColumnDefs": [{
            'bSortable': false,
            'aTargets': [5]
        }],
        aoColumns: [
            null,
            null,
            null,
            null,
            null,
            {sClass: 'text-center cell-buttons-wrapper'}
        ],
        fnHeaderCallback: function( nHead, aData, iStart, iEnd, aiDisplay ) {
            $('#contacts-table_filter input').addClass('form-control input-small').css('margin-left', '10px');
            //$('#contacts-table_length" select').select2();
        },
        fnDrawCallback: function( oSettings ) {
            $('[data-toggle="tooltip"]').tooltip();
            $('.need-confirm').click(function(e) {
                if (!confirm("Etes-vous sûr de vouloir supprimer ce contact ?")) {
                    e.preventDefault();
                }
            });
        },
        aaSorting: [],
        language: {
            url: base_url + 'assets/plugins/data-tables/i18n/French.json'
        },
        oSearch: {
            sSearch: contactsInitialSearch
        }
    });

    $('#group-export').multiSelect({
        selectableHeader: "<input type='text' class='form-control search-input' autocomplete='off' placeholder='Rechercher ...'>",
        selectionHeader: "<input type='text' class='form-control search-input' autocomplete='off' placeholder='Rechercher ...'>",
        afterInit: function (ms) {
            var that = this,
                $selectableSearch = that.$selectableUl.prev(),
                $selectionSearch = that.$selectionUl.prev(),
                selectableSearchString = '#' + that.$container.attr('id') + ' .ms-elem-selectable:not(.ms-selected)',
                selectionSearchString = '#' + that.$container.attr('id') + ' .ms-elem-selection.ms-selected';

            that.qs1 = $selectableSearch.quicksearch(selectableSearchString)
                .on('keydown', function (e) {
                    if (e.which === 40) {
                        that.$selectableUl.focus();
                        return false;
                    }
                });

            that.qs2 = $selectionSearch.quicksearch(selectionSearchString)
                .on('keydown', function (e) {
                    if (e.which == 40) {
                        that.$selectionUl.focus();
                        return false;
                    }
                });
        },
        afterSelect: function () {
            this.qs1.cache();
            this.qs2.cache();
        },
        afterDeselect: function () {
            this.qs1.cache();
            this.qs2.cache();
        }
    });

});
