jQuery(function($) {

    $('#societes-table').dataTable({
        "bProcessing": true,
        "bServerSide": true,
        "sAjaxSource": base_url + "admin/societes/get_data",
        "aLengthMenu": [
            [25, 50, 100, -1],
            [25, 50, 100, "Tous"] // change per page values here
        ],
        "iDisplayLength": 25,
        "sPaginationType": "bootstrap",
        "aoColumnDefs": [{
            'bSortable': false,
            'aTargets': [2]
        }],
        aoColumns: [
            null,
            {sClass: 'text-center cell-buttons-wrapper'},
            {sClass: 'text-center cell-buttons-wrapper'}
        ],
        fnHeaderCallback: function( nHead, aData, iStart, iEnd, aiDisplay ) {
            $('#societes-table_filter input').addClass('form-control input-small').css('margin-left', '10px');
            //$('#contacts-table_length" select').select2();
        },
        fnDrawCallback: function( oSettings ) {
            $('[data-toggle="tooltip"]').tooltip();
            $('.need-confirm').click(function(e) {
                if (!confirm("Etes-vous sûr de vouloir supprimer cette société ?\nCeci supprimera aussi les contacts liés à cette société.")) {
                    e.preventDefault();
                }
            });
        },
        aaSorting: [],
        language: {
            url: base_url + 'assets/plugins/data-tables/i18n/French.json'
        }
    });

});
