<?php

class Contacts extends AdminApp {

    public function __construct()
    {
        parent::__construct();
        $this->parent_menu_active = 'contacts';
    }

    public function index()
    {
    	$this->menu_active = 'contacts-list';

	    $this->addStylesheet(asset_url('plugins/data-tables/DT_bootstrap.css'));
	    $this->addStylesheet(asset_url('plugins/jquery-multi-select/css/multi-select.css'));
	    $this->addScript(asset_url('plugins/data-tables/jquery.dataTables.min.js'));
	    $this->addScript(asset_url('plugins/data-tables/DT_bootstrap.js'));
	    $this->addScript(asset_url('plugins/jquery-multi-select/js/jquery.multi-select.js'));
	    $this->addScript(asset_url('plugins/jquery-multi-select/js/jquery.quicksearch.js'));
    	$this->addScript(asset_url('js/contacts.js'));

	    $groupes = new GroupeTable();
		$contactsInitialSearch = '';

	    if (isset($_GET['id_societe']) && $_GET['id_societe']) {
		    $societe = new SocietesTable();
		    $societeItem = $societe->get_by(array('id' => $_GET['id_societe']), '=', true);
		    $contactsInitialSearch = $societeItem->nom;
	    }

	    $this->render('contacts', array(
		    'groupes' => $groupes->get_all(),
		    'contactsInitialSearch' => $contactsInitialSearch,
	    ));
    }

	public function get_data()
	{

		$iTotal = $this->db->get_var('SELECT COUNT(*) FROM contacts');

		$sWhere = $sOrder = $sLimit = "";

		if ( isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1' ) {
			$sLimit = "LIMIT " . $_GET['iDisplayStart'] . ", " . $_GET['iDisplayLength'];
		}

		if ( isset($_GET['sSearch']) && $_GET['sSearch'] != "" ) {
			$gss = $_GET['sSearch'];
			if (strpos($gss,"'")!==false) {
				$gss = str_replace("'",'.:.APOS.:.',$gss);
				$gss = str_replace('.:.APOS.:.',"\\'",$gss);
			}
			$sWhere = "WHERE (
							contacts.nom LIKE '%{$gss}%'
							OR contacts.prenom LIKE '%{$gss}%'
							OR societes.nom LIKE '%{$gss}%' 
						) ";
		}


		if ( isset($_GET['iSortCol_0']) ) {

			switch ($_GET['iSortCol_0']) {
				case '0':
					$sort_field = 'contacts.nom';
					break;
				case '1':
					$sort_field = 'contacts.prenom';
					break;
				case '2':
					$sort_field = 'nom_societe';
					break;
				case '3':
					$sort_field = 'contacts.create_date';
					break;
				case '4':
					$sort_field = 'contacts.tel';
					break;
			}

			$sOrder = "ORDER BY $sort_field {$_GET['sSortDir_0']} ";

		}


		$sql   = "SELECT SQL_CALC_FOUND_ROWS contacts.id, contacts.nom, contacts.prenom, contacts.id_societe, societes.nom AS nom_societe, contacts.create_date, contacts.tel
				  FROM contacts
				  LEFT JOIN societes ON (societes.id = contacts.id_societe)
				  $sWhere
				  $sOrder
				  $sLimit";

		$results = $this->db->get_results($sql);

		$iFilteredTotal = $this->db->get_var('SELECT FOUND_ROWS()');

		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);

		$alerte = new AlertesTable();

		foreach ($results as $result) {

			$row_actions = '<a href="' . site_url('admin/contacts/edit/' . $result->id) . '" class="btn default btn-xs" title="Modifier" data-toggle="tooltip" data-placement="left"><i class="icon-edit"></i></a>';

			if (!$alerte->hasAlert($result->id)) {
				$row_actions .= '<a href="' . site_url('admin/contacts/alerte/' . $result->id) . '" class="btn default btn-xs" title="Créer une alerte" data-toggle="tooltip" data-placement="left"><i class="icon-bell"></i></a>';
			} else {
				$row_actions .= '<a href="' . site_url('admin/contacts/alerte/' . $result->id) . '" class="btn green btn-xs" title="Modifier alerte" data-toggle="tooltip" data-placement="left"><i class="icon-bell"></i></a>';
			}

			$row_actions .= '<a href="' . site_url('admin/contacts/delete/' . $result->id) . '" class="btn btn-danger btn-xs black need-confirm" title="Supprimer" data-toggle="tooltip" data-placement="left"><i class="icon-trash"></i></a>';

			$output['aaData'][] = array(
				$result->nom,
				$result->prenom,
				'<a href="' . site_url('admin/contacts/?id_societe=' . $result->id_societe) . '">' . $result->nom_societe . '</a>',
				$result->create_date,
				$result->tel,
				$row_actions,
			);
		}

		echo json_encode( $output );

	}

    public function import()
    {
    	$this->menu_active = 'contacts-import';
    	$this->addScript(asset_url('plugins/bootstrap-fileinput/js/fileinput.min.js'));
    	$this->addScript(asset_url('js/contacts-import.js'));
    	$this->addStylesheet(asset_url('plugins/bootstrap-fileinput/css/fileinput.min.css'));
    	$this->render('contacts-import', array());
    }

    public function do_import()
    {
    	if ($_FILES['import']['error'] === 0 && $_FILES['import']['type'] == 'text/csv') {

			$uploaddir = ROOTDIR . 'uploads/';
			$uploadfile = $uploaddir . basename($_FILES['import']['name']);

			if (move_uploaded_file($_FILES['import']['tmp_name'], $uploadfile)) {

				$societe = new SocietesTable();
				$contact = new ContactTable();
				$groupe = new GroupeTable();
				$pays = new PaysTable();

				$inserted = 0;
				$duplicate = 0;
			    $row = 0;

				ini_set("auto_detect_line_endings", '1');

				if (($handle = fopen($uploadfile, "r")) !== FALSE) {

    				while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
						$row++;
    					if ($_POST['ignore_first_line'] && $row == 1) continue;

    					if (count($data) != 16) {
    						$this->msg->add('danger', 'Erreur structure CSV, le fichier devrait contenir 15 colonnes.', site_url('admin/contacts/import'));
    						exit();
    					}

    					if ($contact->exists($data[4])) {
						    $duplicate++;
						    continue;
					    }

					    $id_societe = $societe->exists($data[10]);
					    if ($data[10] && !$id_societe) {
						    $id_societe = $societe->insert(array('nom' => $data[10], 'create_date' => date('Y-m-d')));
					    }

					    $id_groupe = $groupe->exists($data[11]);
					    if ($data[11] && !$id_groupe) {
						    $id_groupe = $groupe->insert(array('groupe' => $data[11]));
					    }

					    $id_pays = null;
					    if ($pays_row = $pays->get_by(array('nom_pays' => $data[12]), '=', true)) {
						    $id_pays = $pays_row->id_pays;
					    }

					    if ($data[0] == 'MLE') $data[0] = 'MLLE';
					    if ($data[0] == 'selected') $data[0] = '';

					    $contact->insert(array(
						    'civilite' => strtolower($data[0]),
						    'nom' => $data[1],
						    'prenom' => $data[2],
						    'tel' => $data[3],
						    'mail' => $data[4],
						    'id_societe' => $id_societe,
						    'adresse1' => $data[5],
						    'adresse2' => $data[6],
						    'adresse3' => $data[7],
						    'cp' => str_replace(' ', '', $data[8]),
						    'ville' => $data[9],
							'id_groupe' => $id_groupe,
						    'id_pays' => $id_pays,
						    'create_date' => date('Y-m-d'),
					    ));

					    $inserted++;

    				}

					$this->msg->add('success', sprintf('<strong>Fichier importé</strong><br>%d insertion(s)<br>%d doublon(s)', $inserted, $duplicate), site_url('admin/contacts/import'));

    			}

			} else {
			    
				echo 'Upload error !';

			}

		}
    }

    public function add()
    {
	    $this->menu_active = 'contacts-add';
        $this->edit(array(0));
    }

    public function edit($args)
    {
	    $id = $args[0];
	    $this->addStylesheet(asset_url('plugins/select2/select2_metro.css'));
	    $this->addStylesheet(asset_url('plugins/bootstrap-datepicker/css/datepicker.css'));
	    $this->addScript(asset_url('plugins/select2/select2.js'));
	    $this->addScript(asset_url('plugins/select2/select2_locale_fr.js'));
	    $this->addScript(asset_url('plugins/bootstrap-datepicker/js/bootstrap-datepicker.js'));
	    $this->addScript(asset_url('plugins/bootstrap-datepicker/js/locales/bootstrap-datepicker.fr.js'));
	    $this->addScript(asset_url('js/contacts-edit.js'));


        $row = $this->db->get_row($this->db->prepare("SELECT *
                                                      FROM contacts 
                                                      WHERE id = %d", $id));
	    $pays = new PaysTable();
	    $groupe = new GroupeTable();
	    $societe = new SocietesTable();
        $this->render('contacts-edit', array(
	        'pays' => $pays->get_all(),
	        'groupes' => $groupe->get_all(),
            'row' => $row,
            'id' => $id,
	        'contactSociete' => $societe->get_by(array('id' => $row->id_societe), '=', true)
        ));
    }

	public function alerte($args)
	{

		$this->addStylesheet(asset_url('plugins/bootstrap-datepicker/css/datepicker.css'));
		$this->addStylesheet(asset_url('plugins/bootstrap-datetimepicker/css/datetimepicker.css'));
		$this->addScript(asset_url('plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js'));
		$this->addScript(asset_url('plugins/bootstrap-datetimepicker/js/locales/bootstrap-datetimepicker.fr.js'));
		$this->addScript(asset_url('js/contacts-alert.js'));

		$id_contact = $args[0];
		$alerte = $this->db->get_row($this->db->prepare('SELECT * FROM alertes WHERE id_contact = %d', $id_contact));
		$contact = new ContactTable();

		$this->render('contacts-alert', array(
			'id_contact' => $id_contact,
			'contact' => $contact->get_by(array('id' => $id_contact), '=', true),
			'alerte' => $alerte,
		));

	}

	public function alerte_save()
	{
		$id = (int)$_POST['id'];
		$data = array(
			'id_contact' => (int)$_POST['id_contact'],
			'alerte_date' => $_POST['alerte_date'],
			'contenu' => $_POST['contenu'],
		);
		if ($id) {
			$this->db->update('alertes', $data, array('id' => $id));
		} else {
			$data['create_date'] = date('Y-m-d H:i:s');
			$this->db->insert('alertes', $data);
		}
		$this->msg->add('success', 'Alerte enregistrée', site_url('admin/contacts'));
	}

    public function save()
    {

	    $id = (int)$_POST['id'];
	    $data = array(
		    'civilite' => $_POST['civilite'],
		    'nom' => mb_strtoupper($_POST['nom'], 'utf8'),
		    'prenom' => mb_strtoupper($_POST['prenom'], 'utf8'),
		    'id_societe' => $_POST['societe'],
		    'fonction' => $_POST['fonction'],
		    'adresse1' => $_POST['adresse1'],
		    'adresse2' => $_POST['adresse2'],
		    'adresse3' => $_POST['adresse3'],
		    'cp' => $_POST['cp'],
		    'ville' => mb_strtoupper($_POST['ville'], 'utf8'),
		    'id_pays' => $_POST['id_pays'],
		    'tel' => $_POST['tel'],
		    'fax' => $_POST['fax'],
		    'mail' => $_POST['email'],
		    'gsm' => $_POST['gsm'],
		    'skype' => $_POST['skype'],
		    'id_groupe' => $_POST['id_groupe'],
		    'note' => $_POST['note'],
		    'emailing' => $_POST['emailing'],
		    'npai' => (int)$_POST['npai'],
		    'npai_date' => $_POST['npai_date'],
		    'desinscrit' => (int)$_POST['desinscrit'],
		    'desinscrit_date' => $_POST['desinscrit_date'],
	    );

	    if ($id) {
			$this->db->update('contacts', $data, array('id' => $id));
	    } else {
		    $data['create_date'] = date('Y-m-d');
			$this->db->insert('contacts', $data);
	    }

	    $this->msg->add('success', 'Contact enregistré', site_url('admin/contacts'));

    }

    public function delete($args)
    {
        $id = $args[0];
        $this->db->delete('contacts', array('id' => $id));
        $this->msg->add('success', 'Contact supprimé', site_url('admin/contacts'));
    }


	public function export_csv()
	{

		$where = '';

		if (isset($_POST['group_export']) && count($_POST['group_export'])) {
			$where = 'WHERE contacts.id_groupe IN (' . implode(',', $_POST['group_export']) . ')';
		}

		$sql   = "SELECT contacts.*, societes.nom AS nom_societe, pays.nom_pays, groupes.groupe
				  FROM contacts
				  LEFT JOIN societes ON (societes.id = contacts.id_societe)
				  LEFT JOIN pays ON (pays.id_pays = contacts.id_pays)
				  LEFT JOIN groupes ON (groupes.id = contacts.id_groupe)
				  $where";
		$rows = $this->db->get_results($sql);

		ini_set("auto_detect_line_endings", '1');
		$filename = 'export-' . date('Y-m-d') . '.csv';
		$delimiter = ';';
		$enclosure = '"';

		header( 'Content-Type: text/csv' );
		header( 'Content-Disposition: attachment;filename='.$filename);
		$out = fopen('php://output', 'w');

		fputcsv($out, array(
			'Email',
			'Civilite',
			'Nom',
			'Prenom',
			'Telephone',
			'Adresse1',
			'Adresse2',
			'Adresse3',
			'CP',
			'Ville',
			'Societe',
			'Groupe',
			'Pays',
			'Utilisateur',
			'Date Ajout'
		), $delimiter, $enclosure);

		foreach ($rows as $row) {
			$data = array(
				$row->mail,
				strtoupper($row->civilite),
				$row->nom,
				$row->prenom,
				$row->tel,
				$row->adresse1,
				$row->adresse2,
				$row->adresse3,
				$row->cp,
				$row->ville,
				$row->nom_societe,
				$row->groupe,
				$row->nom_pays,
				'',
				$row->create_date,
			);
			$data = array_map('utf8_decode', $data);
			fputcsv($out, $data, $delimiter, $enclosure);
		}

		fclose($out);

	}

}