<?php

class Mdworks extends App {

    public function __construct()
    {
        parent::__construct();
    }

	public function index() {

		header('Content-Type: text/html; charset=utf-8');
		?>
		<html>
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
			<title>Interaction avec MDworks</title>
		</head>
		<body>
			<h1>Interaction avec MDworks</h1>
		</body>
		</html>
		<?php
	}

	public function maj($periode_en_jours=1) {
		if (empty($periode_en_jours)) $periode_en_jours = 1;
		if (is_array($periode_en_jours) && array_key_exists(0,$periode_en_jours)) $periode_en_jours = $periode_en_jours[0];
		if (preg_match('/^[0-9.]+$/',$periode_en_jours)) $periode_en_jours = 1*$periode_en_jours; else $periode_en_jours = 1;

		require_once(ROOTDIR . 'includes/mdworks-lib.php');

		$periode_en_jours = min(1*$periode_en_jours , MDWORKS_MAX_PERIOD);
		$periode_en_secondes = 3600*24*$periode_en_jours;

		header('Content-Type: text/html; charset=utf-8');
		echo '<pre>';
		global $success; $npai = majTousNpai($periode_en_secondes); $success_npai = $success;
		$unsubscribe = majTousDesinscrits($periode_en_secondes); $success_unsubs = $success;
		echo 'date : ', @date('Y-m-d H:i:s', time() ) , PHP_EOL;
		echo 'période : ', $periode_en_secondes ,'sec' , PHP_EOL;
		echo 'npai : ', $success_npai,'/',$npai , PHP_EOL;
		echo 'désinscrits : ', $success_unsubs,'/',$unsubscribe , PHP_EOL;
		echo '</pre>';
	}

	public function phpinfo() {
		phpinfo();
	}

	public function log() {
		header('Content-Type: application/text; charset=utf-8');
		header('Content-Disposition: attachment; filename=mdworks.log'); 
		header('Cache-Control: max-age=0');
		echo @date('Y-m-d H:i:s'),PHP_EOL;
		readfile(ROOTDIR . 'includes/mdworks.log');
		die;
	}

	public function status() {
		require_once(ROOTDIR . 'includes/mdworks-lib.php');
		header('Content-Type: text/html; charset=utf-8');
		?>
		<html>
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
			<title>Interaction avec MDworks : Status</title>
		</head>
		<body>
			<h1>Interaction avec MDworks : Status</h1>
			<?php echo infosMDworks(); ?>
		</body>
		</html>
		<?php
	}

	public function majadressesocietes() {

		//méthode directe

		if ($this->db->query("UPDATE societes AS s
			INNER JOIN contacts AS c ON s.id = c.id_societe AND c.adresse1<>'' AND c.adresse1 IS NOT NULL
			SET s.adresse1 	= c.adresse1,
			  s.adresse2 	= c.adresse3,
			  s.adresse3 	= c.adresse2,
			  s.cp 			= c.cp,
			  s.ville 		= c.ville,
			  s.id_pays 	= c.id_pays,
			  s.fax 		= c.fax
			WHERE  (s.adresse1 = '' or s.adresse1 IS NULL)")) {

			header('Content-Type: text/html; charset=utf-8');
			echo $this->db->last_query, ' : ', false!==$res ? $this->db->rows_affected : $this->db->last_error , '<br>';

		} else {

			// méthode société par société

			if ($this->db->query("SELECT DISTINCT s.id,
					c.`adresse1` as c_adresse1,
					c.`adresse2` as c_adresse2,
					c.`adresse3` as c_adresse3,
					c.`cp` as c_cp,
					c.`ville` as c_ville,
					c.`id_pays` as c_id_pays,
					c.`fax` as c_fax 
				FROM `societes` s 
				INNER JOIN `contacts` c ON c.`id_societe`=s.`id` AND c.`adresse1` IS NOT NULL AND c.`adresse1`<>''
				WHERE s.`adresse1` IS NULL OR s.`adresse1`='' ")) {
				
				header('Content-Type: text/html; charset=utf-8');
				echo $this->db->last_query, ' : ', false!==$res ? $this->db->num_rows : $this->db->last_error , '<br>';

				$societes = array();
				foreach($this->db->last_result as $societe) {
					$id_societe = $societe->id;
					if (array_key_exists($id_societe, $societes)) continue;
					$societes[ $id_societe ] = $societe;
				}
				
				foreach($societes as $id_societe => $societe) {
					$res = $this->db->update('societes', array(
						'adresse1'	=> $societe['c_adresse1'],
						'adresse2'	=> $societe['c_adresse2'],
						'adresse3'	=> $societe['c_adresse3'],
						'cp'		=> $societe['c_cp'],
						'ville'		=> $societe['c_ville'],
						'id_pays'	=> $societe['c_id_pays'],
						'fax'		=> $societe['c_fax'],
					), array('id' =>$id_societe) );
					echo $this->db->last_query, ' : ', false!==$res ? $this->db->rows_affected : $this->db->last_error , '<br>';
				}
				
			}

		}

		
	}
}