<?php

class Societes extends AdminApp {

    public function __construct()
    {
        parent::__construct();
        $this->parent_menu_active = 'societes';
    }

    public function index()
    {
    	$this->menu_active = 'societes-list';

	    $this->addStylesheet(asset_url('plugins/data-tables/DT_bootstrap.css'));
	    $this->addScript(asset_url('plugins/data-tables/jquery.dataTables.min.js'));
	    $this->addScript(asset_url('plugins/data-tables/DT_bootstrap.js'));
    	$this->addScript(asset_url('js/societes.js'));

        $this->render('societes', array());
    }

	public function get_data()
	{

		$iTotal = $this->db->get_var('SELECT COUNT(*) FROM societes');

		$sWhere = $sOrder = $sLimit = "";

		if ( isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1' ) {
			$sLimit = "LIMIT " . $_GET['iDisplayStart'] . ", " . $_GET['iDisplayLength'];
		}

		if ( isset($_GET['sSearch']) && $_GET['sSearch'] != "" ) {
			$sWhere = "WHERE (
							societes.nom LIKE '%{$_GET['sSearch']}%'
						) ";
		}


		if ( isset($_GET['iSortCol_0']) ) {

			switch ($_GET['iSortCol_0']) {
				case '0':
					$sort_field = 'societes.nom';
					break;
				case '1':
					$sort_field = 'nb_contacts';
					break;
			}

			$sOrder = "ORDER BY $sort_field {$_GET['sSortDir_0']} ";

		}


		$sql   = "SELECT SQL_CALC_FOUND_ROWS societes.id, societes.nom, (
						SELECT COUNT(*) FROM contacts WHERE id_societe = societes.id
				  ) AS nb_contacts
				  FROM societes
				  $sWhere
				  $sOrder
				  $sLimit";

		$results = $this->db->get_results($sql);

		$iFilteredTotal = $this->db->get_var('SELECT FOUND_ROWS()');

		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);

		foreach ($results as $result) {

			$row_actions = '<a href="' . site_url('admin/societes/edit/' . $result->id) . '" class="btn default btn-xs" title="Modifier" data-toggle="tooltip" data-placement="left"><i class="icon-edit"></i></a>';
			$row_actions .= '<a href="' . site_url('admin/societes/delete/' . $result->id) . '" class="btn btn-danger btn-xs black need-confirm" title="Supprimer" data-toggle="tooltip" data-placement="left"><i class="icon-trash"></i></a>';

			$output['aaData'][] = array(
				'<a href="' . site_url('admin/contacts/?id_societe=' . $result->id) . '">' . $result->nom . '</a>',
				$result->nb_contacts,
				$row_actions,
			);
		}

		echo json_encode( $output );

	}

    public function add()
    {
        $this->edit(array(0));
    }

    public function edit($args)
    {

	    $this->addStylesheet(asset_url('plugins/select2/select2_metro.css'));
	    $this->addScript(asset_url('plugins/select2/select2.js'));
	    $this->addScript(asset_url('plugins/select2/select2_locale_fr.js'));
	    $this->addScript(asset_url('js/societes-edit.js'));

        $id = $args[0];
        $row = $this->db->get_row($this->db->prepare("SELECT *
                                                      FROM societes 
                                                      WHERE id = %d", $id));
	    $pays = new PaysTable();
	    $nafs = new NafTable();
	    $activites = new ActivitesTable();
        $this->render('societes-edit', array(
	        'pays' => $pays->get_all(),
	        'nafs' => $nafs->get_all(),
	        'activites' => $activites->get_all(),
            'row' => $row,
            'id' => $id,
        ));
    }

    public function save()
    {
        $id = (int)$_POST['id'];
	    $data = array(
		    'nom' => $_POST['nom'],
		    'adresse1' => $_POST['adresse1'],
		    'adresse2' => $_POST['adresse2'],
		    'adresse3' => $_POST['adresse3'],
		    'cp' => $_POST['cp'],
		    'ville' => $_POST['ville'],
		    'id_pays' => $_POST['id_pays'],
		    'tel' => $_POST['tel'],
		    'fax' => $_POST['fax'],
		    'web' => $_POST['web'],
		    'statut' => $_POST['statut'],
		    'statut_administrative' => $_POST['statut_administrative'],
		    'siret' => $_POST['siret'],
		    'rcs' => $_POST['rcs'],
		    'tva_intra' => $_POST['tva_intra'],
		    'id_naf' => $_POST['id_naf'],
		    'capital' => $_POST['capital'],
		    'nb_salaries' => $_POST['nb_salaries'],
		    'note' => $_POST['note'],
		    'id_activite' => $_POST['id_activite'],
	    );

	    if ($id) {
		    $this->db->update('societes', $data, array('id' => $id));
	    } else {
		    $data['create_date'] = date('Y-m-d');
		    $this->db->insert('societes', $data);
	    }

	    $this->msg->add('success', 'Société enregistrée', site_url('admin/societes'));

    }

    public function delete($args)
    {
        $id = $args[0];
        $this->db->delete('societes', array('id' => $id));
	    $this->db->delete('contacts', array('id_societe' => $id));
        $this->msg->add('success', 'Société supprimée', site_url('admin/societes'));
    }

	public function get_list_xhr()
	{

		header('Cache-Control: no-cache, must-revalidate');
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Content-type: application/json');

		$results = $this->db->get_results($this->db->prepare('SELECT id, nom
										   					  FROM societes
										   					  WHERE nom LIKE %s
										   					  LIMIT %d', '%' . $_GET['q'] . '%', $_GET['page_limit']));

		$results_formated = array();

		foreach ($results as $r) {
			$results_formated[] = array(
				'id' => $r->id,
				'text' => $r->nom,
			);
		}

		echo json_encode(array(
			'more' => false,
			'results' => $results_formated,
		));

		die();

	}

	public function get_info()
	{
		$id = $_GET['id_societe'];
		$societe = $this->db->get_row($this->db->prepare('SELECT adresse1, adresse2, adresse3, cp, ville, id_pays
														  FROM societes
														  WHERE id = %d', $id));

		header('Cache-Control: no-cache, must-revalidate');
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Content-type: application/json');

		echo json_encode($societe);

		die();

	}

}