<?php
class Users extends AdminApp {

	public function __construct() {
		parent::__construct();
		if ($_SESSION['user']->group != 'admin') {
			$this->msg->add('danger', "Accès réservé aux administrateurs.", site_url('admin/'));
		}
		$this->parent_menu_active = 'users';
	}

	public function index() {
		$this->addScript(asset_url('js/users.js'));
		$users = new UsersTable();
		$this->render( 'users', array(
			'users' => $users->get_all(),
		));
	}

	public function save() {

		$user_id = (int)$_POST['id'];
		$data = array(
			'username' => $_POST['username'],
			'nom' => $_POST['nom'],
			'prenom' => $_POST['prenom'],
			'email' => $_POST['email'],
			'tel' => $_POST['tel'],
			'group' => $_POST['group'],
		);

		if ($_POST['password'] && ($_POST['password'] == $_POST['password2'])) {
			$data['password'] = md5($_POST['password']);
		}

		if ($user_id) {
			$this->db->update('users', $data, array('id' => $user_id));
		} else {
			$this->db->insert('users', $data);
		}

		$this->msg->add('success', 'Utilisateur enregistré.', site_url('admin/users/'));

	}

	public function add() {
		$this->edit(array(0));
	}

	public function edit($args) {
		$user_id = $args[0];
		$users = new UsersTable();
		$this->render( 'users-edit', array(
			'user' => $users->get_by(array('id' => $user_id), '=', true),
			'user_id' => $user_id,
		));
	}

	public function delete($args) {
		$user_id = $args[0];
		$this->db->delete('users', array('id' => $user_id));
		$this->msg->add('success', 'Utilisateur supprimé.', site_url('admin/users/'));
	}

}