<?php

class App {

	var $menu_active;
    var $parent_menu_active;
	var $db;
	var $scripts = array();
	var $stylesheets = array();
    var $user;
    var $pageTitle;
    var $msg;

	public function __construct() 
	{
		global $wpdb;
		$this->db = $wpdb;
        if (!session_id()) session_start();
        $this->user = (isset($_SESSION['user']) ? $_SESSION['user'] : null);
        $this->pageTitle = SITE_NAME;
        $this->msg = new Messages();
	}

	public function render($view, $data = array(), $layout = 'layout-front.php')
	{
		ob_start();
		if (is_array($data)) extract($data);
		require_once('views/' . $view . '.php');
		$buffer = ob_get_contents();
		ob_end_clean();
		require_once('views/' . $layout);
	}

    public function renderComponent($view, $data = array())
    {
        ob_start();
        extract($data);
        require_once('views/' . $view . '.php');
        $buffer = ob_get_contents();
        ob_end_clean();
        echo $buffer;
    }

	public function addScript($src)
	{
		$this->scripts[] = $src;
	}

	public function addStylesheet($href)
	{
		$this->stylesheets[] = $href;
	}
	
}

class AdminApp extends App {

    public function __construct()
    {
        parent::__construct();
        if ($this->user === null) redirect('admin/login');

        $this->pageTitle = 'Admin ' . SITE_NAME;

    }

    public function render($view, $data = NULL, $layout = 'layout-admin.php')
    {
        parent::render($view, $data, $layout);
    }

}

/* Helper functions */

function site_url($path = NULL) {
	return SITE_URL . $path;
}

function asset_url($path = NULL) {
    return SITE_URL . 'assets/' . $path;
}

function base_url() {
	return SITE_URL;
}

function home_url() {
    return site_url();
}

function redirect($url) {
	header('Location: ' . SITE_URL . $url);
}

function dateFRtoMySQL($date) {
    if (!$date) return;
    $dateArray = explode('/', $date);
    return $dateArray[2] . '-' . $dateArray[1] . '-' . $dateArray[0];
}

function dateMySQLtoFR($date) {
    if (!$date) return;
    $dateArray = explode('-', $date);
    return $dateArray[2] . '/' . $dateArray[1] . '/' . $dateArray[0];
}

function d($var) {
    echo '<pre>';
    if (is_array($var)) print_r($var);
    else var_dump($var);
    die();
}

function get_option($option) {
    $option = new Table('options');
    $row = $option->get_by(array('option' => $option), '=', true);
    return $row->value;
}

function set_option($option, $value) {
    $option = new Table('options');
    $option->update(array('value' => $value), array('option' => $option));
}

