<?php
/**
 * Abstract class which has helper functions to get data from the database
 */
abstract class Base_Custom_Data
{
    /**
     * The current table name
     *
     * @var boolean
     */
    private $tableName = false;

    /**
     * Constructor for the database class to inject the table name
     *
     * @param String $tableName - The current table name
     */
    public function __construct($tableName)
    {
        $this->tableName = $tableName;
    }

    /**
     * Insert data into the current data
     *
     * @param  array  $data - Data to enter into the database table
     *
     * @return InsertQuery Object
     */
    public function insert(array $data)
    {
        global $wpdb;

        if(empty($data))
        {
            return false;
        }

        $wpdb->insert($this->tableName, $data);

        return $wpdb->insert_id;
    }

    /**
     * Get all from the selected table
     *
     * @param  String $orderBy - Order by column name
     *
     * @return Table result
     */
    public function get_all( $orderBy = NULL )
    {
        global $wpdb;

        $sql = 'SELECT * FROM `'.$this->tableName.'`';

        if(!empty($orderBy))
        {
            $sql .= ' ORDER BY ' . $orderBy;
        }

        $all = $wpdb->get_results($sql);

        return $all;
    }

    /**
     * Get a value by a condition
     *
     * @param  Array $conditionValue - A key value pair of the conditions you want to search on
     * @param  String $condition - A string value for the condition of the query default to equals
     *
     * @return Table result
     */
    public function get_by(array $conditionValue, $condition = '=', $returnSingleRow = FALSE)
    {
        global $wpdb;

        try
        {
            $sql = 'SELECT * FROM `'.$this->tableName.'` WHERE ';

            $conditionCounter = 1;
            foreach ($conditionValue as $field => $value)
            {
                if($conditionCounter > 1)
                {
                    $sql .= ' AND ';
                }

                switch(strtolower($condition))
                {
                    case 'in':
                        if(!is_array($value))
                        {
                            throw new Exception("Values for IN query must be an array.", 1);
                        }

                        $implode = implode("','", $value);
                        $sql .= "$field IN ('{$implode}')";
                        break;

                    default:
                        $sql .= $wpdb->prepare('`'.$field.'` '.$condition.' %s', $value);
                        break;
                }

                $conditionCounter++;
            }

            $result = $wpdb->get_results($sql);

            // As this will always return an array of results if you only want to return one record make $returnSingleRow TRUE
            if(count($result) == 1 && $returnSingleRow)
            {
                $result = $result[0];
            }

            return $result;
        }
        catch(Exception $ex)
        {
            return false;
        }
    }

    /**
     * Update a table record in the database
     *
     * @param  array  $data           - Array of data to be updated
     * @param  array  $conditionValue - Key value pair for the where clause of the query
     *
     * @return Updated object
     */
    public function update(array $data, array $conditionValue)
    {
        global $wpdb;

        if(empty($data))
        {
            return false;
        }

        $updated = $wpdb->update( $this->tableName, $data, $conditionValue);

        return $updated;
    }

    /**
     * Delete row on the database table
     *
     * @param  array  $conditionValue - Key value pair for the where clause of the query
     *
     * @return Int - Num rows deleted
     */
    public function delete(array $conditionValue)
    {
        global $wpdb;

        $deleted = $wpdb->delete( $this->tableName, $conditionValue );

        return $deleted;
    }
}


class Table extends Base_Custom_Data {

    public function __construct($tableName)
    {
        parent::__construct($tableName);
    }

}

class ContactTable extends Base_Custom_Data {

	var $id;
	var $civilite;
	var $nom;
	var $prenom;
	var $id_societe;
	var $fonction;
	var $adresse1;
	var $adresse2;
	var $adresse3;
	var $cp;
	var $ville;
	var $id_pays;
	var $tel;
	var $fax;
	var $mail;
	var $gsm;
	var $id_groupe;
	var $note;
	var $create_date;
	var $emailing;

	public function __construct() {
		parent::__construct('contacts');
	}

	public function exists($email) {
		global $wpdb;
		$email = trim($email);
		return $wpdb->get_var($wpdb->prepare('SELECT id
											  FROM contacts
											  WHERE mail = %s', $email));
	}

}

class SocietesTable extends Base_Custom_Data {

	var $id;
	var $nom;
	var $adresse1;
	var $adresse2;
	var $adresse3;
	var $cp;
	var $ville;
	var $id_pays;
	var $tel;
	var $fax;
	var $web;
	var $statut;
	var $statut_administrative;
	var $siret;
	var $rcs;
	var $tva_intra;
	var $id_naf;
	var $capital;
	var $nb_salaries;
	var $create_date;
	var $note;
	var $id_activite;

	public function __construct() {
		parent::__construct('societes');
	}

	public function exists($societe_name) {
		global $wpdb;
		$societe_name = trim($societe_name, " ");
		return $wpdb->get_var($wpdb->prepare('SELECT id
											  FROM societes
											  WHERE nom = %s', $societe_name));
	}

}

class GroupeTable extends Base_Custom_Data {

	var $id;
	var $groupe;

	public function __construct() {
		parent::__construct('groupes');
	}

	public function exists($groupe) {
		global $wpdb;
		$groupe = trim($groupe, " ");
		return $wpdb->get_var($wpdb->prepare('SELECT id
											  FROM groupes
											  WHERE groupe = %s', $groupe));
	}

}

class PaysTable extends Base_Custom_Data {

	var $id_pays;
	var $nom_pays;
	var $code_pays;

	public function __construct() {
		parent::__construct('pays');
	}
}

class NafTable extends Base_Custom_Data {

	var $id;
	var $code;
	var $libelle;

	public function __construct() {
		parent::__construct('naf');
	}

}

class ActivitesTable extends Base_Custom_Data {

	var $id;
	var $activite;

	public function __construct() {
		parent::__construct('activites');
	}

}

class UsersTable extends Base_Custom_Data {

	var $id;
	var $username;
	var $password;
	var $nom;
	var $prenom;
	var $email;
	var $tel;
	var $last_login;

	public function __construct() {
		parent::__construct('users');
	}

}

class AlertesTable extends Base_Custom_Data {

	var $id;
	var $id_contact;
	var $alerte_date;
	var $create_date;
	var $contenu;

	public function __construct() {
		parent::__construct('alertes');
	}

	public function hasAlert($id_contact) {
		global $wpdb;
		return $wpdb->get_var($wpdb->prepare('SELECT COUNT(*) FROM alertes WHERE id_contact = %d', $id_contact));
	}

}