<?php

// This bootstrap php code will work only with php5 with no template engine.
// Stops from reporting any error
// error_reporting(0);

// This is the folder where all your application files are present.
define('CLASSDIR', 'controllers');

include_once('includes/config.php');
include_once('includes/wp-db.php');
include_once('includes/class.messages.php');
include_once('includes/base-custom-data.php');
include_once('includes/app.php');

// Absolute path to the source files, just one level behind public folder
define('BASEDIR', @realpath( dirname (__FILE__).'/'.CLASSDIR).'/' );
define('ROOTDIR', @realpath( dirname (__FILE__)) . '/' );

// Automatic loading of classes by using a function so that you can get rid of all include() calls.

function __autoload($class)
{
    global $file;
	include_once($file);
}

// breaking requesting URI to parts & retrieving the specific arguments, methods & class
$route = '';
$class = '';
$method = '';
$args = null;
$cmd_path = BASEDIR;
$fullpath = '';
$file = '';

if (empty($_GET['route']) ) $route = 'index'; else $route = $_GET['route'];
$route = trim($route, '/');
$parts = explode('/', $route);

global $parts;

foreach($parts as $part)
{
	$part = str_replace('-', '_', $part);
	$fullpath = $cmd_path . $part;

	if (is_dir($fullpath))
	{
		$cmd_path .= $part . '/';
		array_shift($parts);
		continue;
	}

	if (is_file($fullpath.'.php') )
	{
		$class = $part;
		array_shift($parts);
		break;
	}
}

if (empty($class) ) $class = 'index';
	$action = array_shift($parts);
	$action = str_replace('-', '_', $action);

if (empty($action) ) $action = 'index';
	$file = $cmd_path.$class.'.php';
	$args = $parts;

// now that we have the parts , let's run a few more test and then execute the function in the class file
if (is_readable($file) == false)
{
	echo 'Requested module ' . $class . ' is missing.';
	exit();
}

// Sanitize POST data
function my_stripslashes(&$item, $key) {
	$item = stripslashes($item);
}
array_walk_recursive($_POST, 'my_stripslashes');

// load the requested file
$class = new $class();

if (is_callable(array($class, $action) ) == false )
{
	// function not found in controller , set it as index and send it to args
	array_unshift($args, $action);
	$action = 'index';
}

// Run Action
$class->$action($args);