<!DOCTYPE html>
<!--[if IE 8]> <html lang="fr" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="fr" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!--> <html lang="fr" class="no-js"> <!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
    <meta charset="utf-8" />
    <title><?php echo $this->pageTitle; ?></title>
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1.0" name="viewport" />
    <meta name="MobileOptimized" content="320">
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="<?php echo base_url(); ?>assets/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url(); ?>assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url(); ?>assets/plugins/uniform/css/uniform.default.css" rel="stylesheet" type="text/css"/>
    <!-- END GLOBAL MANDATORY STYLES -->

    <?php foreach ($this->stylesheets as $style) : ?>
    <link href="<?php echo $style; ?>" rel="stylesheet" type="text/css"/>
    <?php endforeach; ?>

    <!-- BEGIN THEME STYLES -->
    <link href="<?php echo base_url(); ?>assets/css/style-metronic.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url(); ?>assets/css/style.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url(); ?>assets/css/style-responsive.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url(); ?>assets/css/plugins.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url(); ?>assets/css/themes/default.css" rel="stylesheet" type="text/css" id="style_color"/>
    <link href="<?php echo base_url(); ?>assets/css/custom-admin.css" rel="stylesheet" type="text/css"/>
    <!-- END THEME STYLES -->
    <link rel="shortcut icon" href="favicon.ico" />
</head>
<!-- END HEAD -->
<!-- BEGIN BODY -->
<body class="page-header-fixed">
<!-- BEGIN HEADER -->
<div class="header navbar navbar-inverse navbar-fixed-top">
<!-- BEGIN TOP NAVIGATION BAR -->
<div class="header-inner">
<!-- BEGIN LOGO -->
<a class="navbar-brand" href="<?php echo site_url('admin/'); ?>">
    <img src="<?php echo base_url(); ?>assets/img/logo-big.png" alt="logo" class="img-responsive" />
</a>
<!-- END LOGO -->
<!-- BEGIN RESPONSIVE MENU TOGGLER -->
<a href="javascript:;" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
    <img src="<?php echo base_url(); ?>assets/img/menu-toggler.png" alt="" />
</a>
<!-- END RESPONSIVE MENU TOGGLER -->
<!-- BEGIN TOP NAVIGATION MENU -->
<ul class="nav navbar-nav pull-right">
<!-- BEGIN USER LOGIN DROPDOWN -->
<li class="dropdown user">
    <a href="#" class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
        <img alt="" src="<?php echo base_url(); ?>assets/img/avatar1_small.jpg"/>
        <span class="username"><?php echo $this->user->prenom . ' ' . $this->user->nom; ?></span>
        <i class="icon-angle-down"></i>
    </a>
    <ul class="dropdown-menu">
        <li><a href="<?php echo site_url('admin/account'); ?>"><i class="icon-user"></i> Mon compte</a>
        <li><a href="<?php echo site_url('admin/login/logout'); ?>"><i class="icon-key"></i> Déconnexion</a>
        </li>
    </ul>
</li>
<!-- END USER LOGIN DROPDOWN -->
</ul>
<!-- END TOP NAVIGATION MENU -->
</div>
<!-- END TOP NAVIGATION BAR -->
</div>
<!-- END HEADER -->
<div class="clearfix"></div>
<!-- BEGIN CONTAINER -->
<div class="page-container">
<!-- BEGIN SIDEBAR -->
<div class="page-sidebar navbar-collapse collapse">
<!-- BEGIN SIDEBAR MENU -->
<ul class="page-sidebar-menu">
    <li>
        <!-- BEGIN SIDEBAR TOGGLER BUTTON -->
        <div class="sidebar-toggler hidden-phone"></div>
        <!-- BEGIN SIDEBAR TOGGLER BUTTON -->
    </li>
    <li><br></li>
    <li class="start <?php if ($this->menu_active == 'dashboard') : ?>active<?php endif; ?>">
        <a href="<?php echo site_url('admin/'); ?>">
            <i class="icon-dashboard"></i>
            <span class="title">Tableau de bord</span>
            <span class="selected"></span>
        </a>
    </li>
    <li class="<?php if($this->parent_menu_active == 'societes') : ?>active<?php endif; ?>">
        <a href="javascript:;">
            <i class="icon-briefcase"></i>
            <span class="title">Sociétés</span>
            <span class="arrow <?php if($this->parent_menu_active == 'societes') : ?>open<?php endif; ?>"></span>
            <span class="selected"></span>
        </a>
        <ul class="sub-menu">
            <li class="<?php if ($this->menu_active == 'societes-list') : ?>active<?php endif; ?>">
                <a href="<?php echo site_url('admin/societes/'); ?>">Liste</a>
            </li>
            <li class="<?php if ($this->menu_active == 'societes-add') : ?>active<?php endif; ?>">
                <a href="<?php echo site_url('admin/societes/add'); ?>">Ajout</a>
            </li>
        </ul>
    </li>
    <li class="<?php if($this->parent_menu_active == 'contacts') : ?>active<?php endif; ?>">
        <a href="javascript:;">
            <i class="icon-user"></i>
            <span class="title">Contacts</span>
            <span class="arrow <?php if($this->parent_menu_active == 'contacts') : ?>open<?php endif; ?>"></span>
            <span class="selected"></span>
        </a>
        <ul class="sub-menu">
            <li class="<?php if ($this->menu_active == 'contacts-list') : ?>active<?php endif; ?>">
                <a href="<?php echo site_url('admin/contacts/'); ?>">Contacts</a>
            </li>
            <li class="<?php if ($this->menu_active == 'contacts-add') : ?>active<?php endif; ?>">
                <a href="<?php echo site_url('admin/contacts/add'); ?>">Ajouter un contact</a>
            </li>
            <li class="<?php if ($this->menu_active == 'contacts-import') : ?>active<?php endif; ?>">
                <a href="<?php echo site_url('admin/contacts/import'); ?>">Importation</a>
            </li>
        </ul>
    </li>
	<?php if ($_SESSION['user']->group == 'admin') : ?>
	<li class="<?php if($this->parent_menu_active == 'users') : ?>active<?php endif; ?>">
		<a href="<?php echo site_url('admin/users/'); ?>">
			<i class="icon-group"></i>
			<span class="title">Utilisateurs</span>
		</a>
	</li>
	<?php endif; ?>
</ul>
<!-- END SIDEBAR MENU -->
</div>
<!-- END SIDEBAR -->
<!-- BEGIN PAGE -->
<div class="page-content">
    <?php echo $this->msg->display(); ?>
    <?php echo $buffer; ?>
</div>
<!-- END PAGE -->
</div>
<!-- END CONTAINER -->
<!-- BEGIN FOOTER -->
<div class="footer">
    <div class="footer-inner">
        2014 &copy; <?php echo SITE_NAME; ?>
    </div>
    <div class="footer-tools">
         <span class="go-top">
         <i class="icon-angle-up"></i>
         </span>
    </div>
</div>
<!-- END FOOTER -->
<!-- BEGIN JAVASCRIPTS(Load javascripts at bottom, this will reduce page load time) -->
<script type="text/javascript">
    var base_url = '<?php echo base_url(); ?>';
</script>
<!-- BEGIN CORE PLUGINS -->
<!--[if lt IE 9]>
<script src="<?php echo base_url(); ?>assets/plugins/respond.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/excanvas.min.js"></script>
<![endif]-->
<script src="<?php echo base_url(); ?>assets/plugins/jquery-1.10.2.min.js" type="text/javascript"></script>
<script src="<?php echo base_url(); ?>assets/plugins/jquery-migrate-1.2.1.min.js" type="text/javascript"></script>
<script src="<?php echo base_url(); ?>assets/plugins/jquery-ui/jquery-ui-1.10.3.custom.min.js" type="text/javascript"></script>
<script src="<?php echo base_url(); ?>assets/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<script src="<?php echo base_url(); ?>assets/plugins/bootstrap-hover-dropdown/twitter-bootstrap-hover-dropdown.min.js" type="text/javascript" ></script>
<script src="<?php echo base_url(); ?>assets/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
<script src="<?php echo base_url(); ?>assets/plugins/jquery.blockui.min.js" type="text/javascript"></script>
<script src="<?php echo base_url(); ?>assets/plugins/jquery.cookie.min.js" type="text/javascript"></script>
<script src="<?php echo base_url(); ?>assets/plugins/uniform/jquery.uniform.min.js" type="text/javascript" ></script>
<script src="<?php echo base_url(); ?>assets/scripts/app.js" type="text/javascript"></script>
<!-- END CORE PLUGINS -->

<?php foreach ($this->scripts as $script) : ?>
<script src="<?php echo $script; ?>" type="text/javascript"></script>
<?php endforeach; ?>

<script>
    jQuery(document).ready(function() {
        App.init(); // initlayout and core plugins
    });
</script>
<!-- END JAVASCRIPTS -->
</body>
<!-- END BODY -->
</html>