<div class="row">
	<div class="col-md-12">
		<!-- BEGIN PAGE TITLE & BREADCRUMB-->
		<h3 class="page-title">
			Utilisateurs
		</h3>
		<ul class="page-breadcrumb breadcrumb">
			<li>
				<i class="icon-home"></i>
				<a href="<?php echo site_url('admin/'); ?>">Accueil</a>
				<i class="icon-angle-right"></i>
			</li>
			<li>
				<span>Utilisateurs</span>
			</li>
			<li class="btn-group">
				<a href="<?php echo site_url('admin/users/add'); ?>" class="btn blue"><i class="glyphicon glyphicon-plus"></i> Ajouter un utilisateur</a>
			</li>
		</ul>
		<!-- END PAGE TITLE & BREADCRUMB-->
	</div>
</div>

<div class="row">
	<div class="col-md-12">

		<table class="table table-striped table-hover" id="users-table">
			<thead>
			<tr>
				<th>Login</th>
				<th>Email</th>
				<th>Nom</th>
				<th>Groupe</th>
				<th class="text-center">Actions</th>
			</tr>
			</thead>

			<tbody>
			<?php
			foreach ($users as $user) {
			?>
				<tr>
					<td><?php echo $user->username; ?></td>
					<td><?php echo $user->email; ?></td>
					<td><?php echo $user->prenom . ' ' . $user->nom; ?></td>
					<td><?php echo $user->group; ?></td>
					<td class="text-center">
						<?php if ($user->id == $_SESSION['user']->id) : ?>
							<a href="<?php echo site_url('admin/account'); ?>" class="btn default btn-xs" title="Modifier mon profil" data-toggle="tooltip" data-placement="left"><i class="icon-edit"></i></a>
						<?php else : ?>
							<a href="<?php echo site_url('admin/users/edit/' . $user->id); ?>" class="btn default btn-xs" title="Modifier" data-toggle="tooltip" data-placement="left"><i class="icon-edit"></i></a>
							<a href="<?php echo site_url('admin/users/delete/' . $user->id); ?>" class="btn default btn-xs need-confirm" title="Modifier" data-toggle="tooltip" data-placement="left"><i class="icon-trash"></i></a>
						<?php endif; ?>
					</td>
				</tr>
			<?php
			}
			?>
			</tbody>

		</table>

	</div>
</div>