<?php
// ********************************************************************************************************************
// * Class Fichier
// * Author : KDO COM.CEPTION
// * Version : 1.0.0
// * Copyright 2006 FRANCE ADRESSES
// ********************************************************************************************************************
class Fichier
{
//---------------------------------------------------------------------------------------------------------------------------------------
	private
		$fichierID			= 0,
		$themeID			= 0,
		$nom				= "",
		$numcnil			= "",
		$descr				= "",
		$volume		 		= 0,
		$origine			= "",
		$selection			= "",
		$profil				= "",
		$potentiel			= "",
		$conditions			= "",
		$typeAdresses		= "",
		$exclusivite		= "",
		$docpdf				= "",
		$mots_cles			= "",
		$nouveaute			= "",
		$logo    			= "",
		$fichiers_lies		= "",
		$actif				= "",
		$date_activation	= "",
		$dateCrea			= "",
		$dateModif			= "",
		$download_pdf 		= 0,
		$pathLogos			= "../logos/",
		$strTable       	= "tblfichiers";
//---------------------------------------------------------------------------------------------------------------------------------------
	private function resizeLogo()
	{
	    $thumbWidth = 130;
	    
		if( isset($this->logo) && !empty($this->logo) )
		{
		    	$extension = substr($this->logo, strrpos($this->logo, ".") + 1);
		    	if( $extension == 'jpg' || $extension == 'jpeg' )
    				$srcImg = imagecreatefromjpeg($this->pathLogos . $this->logo);
		    	if( $extension == 'gif' )
    				$srcImg = imagecreatefromgif($this->pathLogos . $this->logo);
		    	if( $extension == 'png' )
    				$srcImg = imagecreatefrompng($this->pathLogos . $this->logo);

    			$origWidth = imagesx($srcImg);
		    	$origHeight = imagesy($srcImg);
    
    			$ratio = $origWidth / $thumbWidth;
    			$thumbHeight = $origHeight / $ratio;
        
    			$thumbImg = imagecreatetruecolor($thumbWidth, $thumbHeight);
		    	imagecopyresampled($thumbImg, $srcImg, 0, 0, 0, 0, $thumbWidth, $thumbHeight, $origWidth, $origHeight);
    
		    	if( $extension == 'jpg' || $extension == 'jpeg' )
			    	imagejpeg($thumbImg, $this->pathLogos . $this->logo);
		    	if( $extension == 'gif' )
			    	imagegif($thumbImg, $this->pathLogos . $this->logo);
		    	if( $extension == 'png' )
			    	imagepng($thumbImg, $this->pathLogos . $this->logo);
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	function __construct($fichierID = null)
	{
		if ( !empty($fichierID) && is_numeric($fichierID) && $fichierID != 0 )
		{
			$this->fichierID = $fichierID;
			$strSQL = "Select nom, themeID, numcnil, descr, volume, origine, selection, profil, potentiel, conditions, typeAdresses, exclusivite, docpdf, mots_cles, nouveaute, logo, fichiers_lies, actif, date_activation, dateCrea, dateModif, download_pdf From " . $this->strTable . " Where fichierID = " . $this->fichierID;
			$arRecords = execSQL($strSQL);
			$arResult = mysqli_fetch_array($arRecords);
			foreach ($arResult as $attr => $value)
			{
            	$this->$attr = $value ;
			}
			unset($arRecords);
        }
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	function __destruct()
	{
			$this->fichierID = 0;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	function getSelectType($value)
	{
		$strSelect = "<option value=\"0\"></option>";
		$strSQL = "Select themeID, theme From tblthemes Order By theme";
		$result = execSQL($strSQL);

		while ( $theme = mysqli_fetch_array($result) )
		{
			$strSelect .= "<option value=\"" . $theme[0] . "\"";
			if ( !empty($value) && ($theme[0] == $value) )
				$strSelect .= " Selected";
			$strSelect .= ">" . utf8_encode($theme[1]);
			$strSelect .= "</option>\n";
		}
		$strSelect .= "</select>";
		mysqli_free_result($result);
		return $strSelect;
	}
//-------------------------------------------------------------------------------------------------------------------------------------------
	public function setThemeID($themeID = 0)
	{
		$this->themeID = $themeID;
	}
	public function getThemeID()
	{
		return $this->themeID;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setNom($nom = "")
	{
		$this->nom = str_replace("", "'", $nom);
	}
	public function getNom()
	{
		return $this->nom;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setNumCnil($numcnil = "")
	{
		$this->numcnil = $numcnil;
	}
	public function getNumCnil()
	{
		return $this->numcnil;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setDescr($descr = "")
	{
		$this->descr = str_replace("", "'", $descr);
	}
	public function getDescr()
	{
		return $this->descr;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setVolume($volume = 0)
	{
		$this->volume = $volume;
	}
	public function getVolume()
	{
		return $this->volume;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setOrigine($origine = "")
	{
		$this->origine = str_replace("", "'", $origine);
	}
	public function getOrigine()
	{
		return $this->origine;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setSelection($selection = "")
	{
		$this->selection = str_replace("", "'", $selection);
	}
	public function getSelection()
	{
		return $this->selection;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setProfil($profil = "")
	{
		$this->profil = str_replace("", "'", $profil);
	}
	public function getProfil()
	{
		return $this->profil;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setPotentiel($potentiel = "")
	{
		$this->potentiel = str_replace("", "'", $potentiel);
	}
	public function getPotentiel()
	{
		return $this->potentiel;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setConditions($conditions = "")
	{
		$this->conditions = str_replace("", "'", $conditions);
	}
	public function getConditions()
	{
		return $this->conditions;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setDocpdf($docpdf = "")
	{
		$this->docpdf = $docpdf;
	}
	public function getDocpdf()
	{
		return $this->docpdf;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setMotsCles($mots_cles = "")
	{
		$this->mots_cles = $mots_cles;
	}
	public function getMotsCles()
	{
		return $this->mots_cles;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setLogo()
	{
		$ListeExtension = array('jpg' => 'image/jpeg', 'jpeg' => 'image/jpeg', 'png' => 'image/png', 'gif' => 'image/gif');

		$justupped = pathinfo($_FILES['logo']['name']);
		$fileout = $this->pathLogos.$_GET['file'].".".$justupped['extension'];

		if( isset($_FILES['logo']['name']) && !empty($_FILES['logo']['name']) )
		{
			if(move_uploaded_file($_FILES['logo']['tmp_name'], $fileout))
			{
				$this->logo = strtolower($_GET['file'].".".$justupped['extension']);
				$this->resizeLogo();
			}
		}
	}
	public function getLogo()
	{
		return $this->logo;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setFichiersLies($fichiers_lies = "")
	{
		$this->fichiers_lies = $fichiers_lies;
	}
	public function getFichiersLies()
	{
		return $this->fichiers_lies;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setActif($actif = "")
	{
		$this->actif = $actif;
	}
	public function getActif()
	{
		return $this->actif;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setDate_Activation($date_activation = "")
	{
		$this->date_activation = $date_activation;
	}
	public function getDate_Activation()
	{
		return $this->date_activation;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setNouveaute($nouveaute = "")
	{
		$this->nouveaute = $nouveaute;
	}
	public function getNouveaute()
	{
		return $this->nouveaute;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setExclusivite($exclusivite = "")
	{
		$this->exclusivite = $exclusivite;
	}
	public function getExclusivite()
	{
		return $this->exclusivite;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function setTypeAdresses($typeAdresses = "")
	{
		$this->typeAdresses = $typeAdresses;
	}
	public function getTypeAdresses()
	{
		return $this->typeAdresses;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function getCompteur()
	{
		return $this->download_pdf;
	}
//----------------------------------------------------------------------------------------------------------------------------------------
	public function parseMotscles()
	{
		$arMotsCles = array();
		$strLinks = '';
		if ( !empty($this->mots_cles) )
		{
			$strLinks .= '<p id="motscles">Pour approfondir votre recherche, vous pouvez cliquer sur un ou plusieurs des mots-cl&eacute;s ci-dessous associ&eacute; &agrave; ce fichier :</p><p id="motscles">'; 
			$arMotsCles = explode(",", $this->mots_cles);
			foreach ( $arMotsCles as $keyWord )
			{
				$strLinks .= '<a href="recherche-de-fichiers-d-adresses.php?q=' . $keyWord . '">' . utf8_decode($keyWord) . '</a> - ';
			}
			$strLinks = substr($strLinks, 0, strlen($strLinks) - 2);
			$strLinks .= '</p>'; 
		}
		unset($arMotsCles);
		return $strLinks;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function getFiles($condition = "")
	{
		$strSQL = "Select fichierID, nom, descr, volume From tblfichiers Where actif = 'OUI'";
		if ( !empty($condition) )
		 	$strSQL .= " AND " . $condition;
		$strSQL .= " Order by nom;";
		$result = execSQL($strSQL);

		$strTable = '<table width="485" align="center" border="0" cellpadding="1" cellspacing="0">';

		if ( !is_null($result) && count($result) > 0 )
		{
			while ( $arFiles = mysqli_fetch_array($result) )
			{
				$strTable .= '<tr bgcolor="#FFFFFF">';
				$strTable .= '<td width="70%"><img src="charte/fiche_icone.jpg" align="absmiddle" alt="fichier adresses, location adresses senior" /><a href="fichier-adresses.php?fiche=' . $arFiles[0] . '" title="' . $arFiles[1] . '"><span class="rtitre"> ' . utf8_decode($arFiles[1]) . '</span></a></td>';
				$strTable .= '<td width="30%" align="right">' . number_format($arFiles[3], 0, "", " ") . ' adresses</td>';
				$strTable .= '</tr>';
				$strTable .= '<tr bgcolor="#FFFFFF">';
				$strTable .= '<td colspan="2"><span class="style3">' . utf8_decode($arFiles[2]) . '</span></td>';
				$strTable .= '</tr>';
				$strTable .= '<tr bgcolor="#FFFFFF">';
				$strTable .= '<td colspan="2">';
				$strTable .= '<div class="style2"><a href="fichier-adresses.php?fiche=' . $arFiles[0] . '" class="lisuite" title="fichier adresses, location adresses senior">Pour lire et imprimer le descriptif complet<img src="charte/fiche_puce.jpg" hspace="7" align="absmiddle" border="0" /></a><br /><a href="comptage-fichier-adresses.php?fiche=' . $arFiles[0] . '" class="lisuite" title="fichier adresses, location adresses senior"> Pour un comptage gratuit sous 48 heures<img src="charte/fiche_puce.jpg" hspace="7" align="absmiddle" border="0" alt="fichier adresses, location adresses senior" /></a></div>';
				$strTable .= '</td>';
				$strTable .= '</tr>';
				$strTable .= '<tr bgcolor="#FFFFFF"><td colspan="2">&nbsp;</td></tr>';
			}
		}
		else
			$strTable .= '<tr bgcolor="#FFFFFF" align="center"><td>Aucun fichier ne correspond &agrave; votre requ&ecirc;te.</td></tr>';
		
		$strTable .= '</table>';
		mysqli_free_result($result);

		return $strTable;
	}
//---------------------------------------------------------------------------------------------------------------------------------------
	public function getAssociatedFiles()
	{
		$strSQL = "Select fichierID, nom, descr, volume From tblfichiers Where actif = 'OUI' AND fichierID IN (" . $this->fichiers_lies . ") Order by nom;";
		$result = execSQL($strSQL);

		$strTable = '<table width="240" align="center" border="0" cellpadding="1" cellspacing="0">';

		if ( !is_null($result) && count($result) > 0 )
		{
			while ( $arFiles = mysqli_fetch_array($result) )
			{
				$strTable .= '<tr bgcolor="#FFFFFF">';
				$strTable .= '<td><img src="charte/fiche-icone-service-plus.jpg" align="absmiddle" alt="fichier adresses, location adresses senior" /><a href="fichier-adresses.php?fiche=' . $arFiles[0] . '" title="' . $arFiles[1] . '"><span class="rtitre-bleu"> ' . $arFiles[1] . '</span></a></td>';
				$strTable .= '</tr>';
			}
		}
		else
			$strTable .= '<tr bgcolor="#FFFFFF" align="center"><td>Aucun fichier ne correspond &agrave; votre requ&ecirc;te.</td></tr>';
		
		$strTable .= '</table>';
		mysqli_free_result($result);

		return $strTable;
	}
//-------------------------------------------------------------------------------------------------------------------------------------------
	public function update()
	{
		global $objMySQL;
		
		$strSQL = "Update tblfichiers Set nom = '" . addslashes(htmlentities($this->nom)) . "', 
		numcnil = '" . addslashes($this->numcnil) . "', 
		descr = '" . addslashes(htmlentities($this->descr)) . "', 
		volume = '" . addslashes(htmlentities($this->volume)) . "', 
		origine = '" . addslashes(htmlentities($this->origine)) . "', 
		selection = '" . addslashes(htmlentities($this->selection)) . "', 
		profil = '" . addslashes(htmlentities($this->profil)) . "', 
		potentiel = '" . addslashes(htmlentities($this->potentiel)) . "', 
		conditions = '" . addslashes(htmlentities($this->conditions)) . "', 
		typeAdresses = '" . addslashes(htmlentities($this->typeAdresses)) . "', 
		mots_cles = '" . addslashes(htmlentities($this->mots_cles)) . "', 
		actif = '" . $this->actif . "', 
		date_activation = " . ( !empty($this->date_activation) ? "'$this->date_activation'" : 'NULL' ) . ",
		nouveaute = '" . $this->nouveaute . "',
		exclusivite = '" . $this->exclusivite . "', 
		fichiers_lies = '" . $this->fichiers_lies . "', 
		themeID = '" . $this->themeID . "', 
		logo = '" . $this->logo . "', 
		dateModif = CURRENT_TIMESTAMP 
		Where fichierID = '" . $this->fichierID . "'";
		execSQL($strSQL);
	}
//-------------------------------------------------------------------------------------------------------------------------------------------
	public function insert()
	{
		global $objMySQL;
		
		$strSQL = "Insert Into tblfichiers(nom, numcnil, descr, volume, origine, selection, profil, potentiel, conditions, typeAdresses, mots_cles, actif, date_activation, nouveaute, exclusivite, fichiers_lies, logo, themeID) Values('" . addslashes($this->nom) . "',
		'" . addslashes($this->numcnil) . "',
		'" . addslashes(htmlentities($this->descr)) . "',
		'" . addslashes(htmlentities($this->volume)) . "',
		'" . addslashes(htmlentities($this->origine)) . "',
		'" . addslashes(htmlentities($this->selection)) . "',
		'" . addslashes(htmlentities($this->profil)) . "',
		'" . addslashes(htmlentities($this->potentiel)) . "',
		'" . addslashes(htmlentities($this->conditions)) . "',
		'" . addslashes(htmlentities($this->typeAdresses)) . "',
		'" . addslashes(htmlentities($this->mots_cles)) . "',
		'" . addslashes($this->actif) . "',
		" . ( !empty($this->date_activation) ? "'$this->date_activation'" : 'NULL' ) . ",
		'" . addslashes($this->nouveaute) . "',
		'" . $this->exclusivite . "',
		'" . addslashes($this->fichiers_lies) . "',
		'" . addslashes($this->logo) . "',
		'" . addslashes($this->themeID) . "')";
		$id= execSQLwid($strSQL);
		return $id;

	}
//---------------------------------------------------------------------------------------------------------------------------------------
}
// ********************************************************************************************************************
?>