<?php
if (!defined('MDWORKS_API_CALLS')) {

	define('MDWORKS_API_CALLS',1);

	// config du script

	define('SOAP_TYPE','extended');
	define('SOAP_CHARSET','ISO-8859-1');
	if (empty($_REQUEST['debug']))
		define('SOAP_DEBUG',0); // mettre à 1 pour afficher les messages de déboggage
	else
		define('SOAP_DEBUG',1);
	define('SOAP_LOG',1);
	define('MDWORKS_DATE_FORMAT','Y-m-d');
	define('MDWORKS_MAX_PERIOD',30); // impossible de récupérer des données d'il y a plus de 10j

	// config du serveur

	$use_nusoap = 
	$use_soapclient =
	$use_curl = 0;
	if ( class_exists('SoapClient') ) $use_soapclient = 1; // si soapclient interne
	else {
		if ( defined('NUSOAP_PATH') ) {
			require_once NUSOAP_PATH.'nusoap.php';
			if (defined('NUSOAP')) $use_nusoap = 1;
		}
	}
	if ( function_exists('curl_exec') ) $use_curl = 1;

	define('USE_NUSOAP',$use_nusoap);
	define('USE_SOAPCLIENT',$use_soapclient);
	define('USE_CURL',$use_curl);

	// config de l'api

	$api_url = MDWORKS_API_URL; $tmp = parse_url($api_url); $api_host = $tmp['scheme'].'//'.$tmp['host'];
	$api_login = MDWORKS_API_LOGIN;
	$api_pwd = MDWORKS_API_PWD;
	define('MDWORKS_API_HOST',$api_host);

	function logMDworks($msg) {
		$dt = @date('Y-m-d H:i:s', time() );
		global $wpdb;
		$cal = $wpdb->get_caller();
		if (defined('SOAP_LOG') && SOAP_LOG)
			error_log("$dt\t$cal\t$msg".PHP_EOL,3,__DIR__.'/mdworks.log');
	}

	function detectMDworksInstall() {
		logMDworks('detectMDworksInstall!');
		error_reporting(E_ALL);
		ini_set('display_errors',1);

		echo '<ul>';
		foreach(array('USE_NUSOAP','USE_SOAPCLIENT','USE_CURL','MDWORKS_API_URL','MDWORKS_API_LOGIN','MDWORKS_API_PWD','MDWORKS_API_HOST') as $const) {
			if (!defined($const))
				echo "<li>La constante '$const' n'est pas défini</li>";
			else
				echo "<li>valeur de la constante $const : '".constant($const)."'</li>";
		}

		echo '</ul>';
	}

	/**
	 * Lance une requete SOAP vers MDworks
	 * @param string $action 
	 * @param array $params 
	 * @return array (FALSE si erreur)
	 */
	function mdworksApiCall($action, $params) {
		logMDworks('mdworksApiCall!');
		if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
			error_reporting(E_ALL);
			ini_set('display_errors',1);
		}

		if (!defined('MDWORKS_API_LOGIN') || ''.MDWORKS_API_LOGIN == '') return false;

		// paramètres de l'api

		$parametres = array('login'=>MDWORKS_API_LOGIN,'motdepasse'=>MDWORKS_API_PWD); foreach($params as $key=>$val) $parametres[$key] = $val;

		// lancement de la requête

		if (USE_SOAPCLIENT) {

			try { 

				switch(SOAP_TYPE) {
					case 'basic':
						$client = new SoapClient(MDWORKS_API_URL);
					break;
					case 'standard':
						$client = new SoapClient(MDWORKS_API_URL, array('encoding' => SOAP_CHARSET));
					break;
					case 'extended':
						$client = new SoapClient(null, array(
							'location' => MDWORKS_API_URL,
							'uri'      => MDWORKS_API_HOST,
							'encoding' => SOAP_CHARSET,
						));
					break;
					default:
						trigger_error("SOAP Fault: Le type de client SOAP n'est pas reconnu : ".constant('SOAP_TYPE'), E_USER_ERROR);
						return false;
				}

				/*
				$client = new SoapClient(null, array(
					'location'	=> MDWORKS_API_URL, //"https://www.eml-srv.com/_soap/control_v2.php",
					'uri'		=> MDWORKS_API_HOST, //"https://www.eml-srv.com",
					'encoding'	=> 'ISO-8859-1'
				));
				//*/
				//$variable = $client->Extrait_Periode($config['login'], $config['motdepasse'],'NPAI','c');

				if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
					echo '<fieldset><legend>$client,$action,$parametres,SOAP_TYPE</legend><pre>';
					var_dump($client,$action,$parametres,SOAP_TYPE);
					echo '</pre></fieldset>';
				}
				logMDworks( var_export($client,true) );
				logMDworks( var_export($action,true) );
				logMDworks( var_export($parametres,true) );

				if ('Extrait_Periode'==$action)
					$variable = $client->Extrait_Periode( MDWORKS_API_LOGIN, MDWORKS_API_PWD, $parametres['type'], $parametres['periode'] );
				else
					$variable = $client->__soapCall($action, $parametres);

				if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
					echo '<fieldset><legend>$variable</legend><pre>';
					var_dump($variable);
					echo '</pre></fieldset>';
				}
				//logMDworks( var_export($variable,true) );

				return $variable; 
			} catch (SoapFault $fault) {
				$message = "SOAP Fault: (faultcode: {$fault->faultcode}, faultstring: {$fault->faultstring}, SOAP type: ".constant('SOAP_TYPE').")";
				if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
					echo '<fieldset><legend>ERREUR!</legend><pre>';
					echo $message;
					echo '</pre></fieldset>';
				}
				trigger_error($message, E_USER_ERROR);
				logMDworks( $message );
				return false;
			}

		} else if (USE_NUSOAP) {

			if (!USE_CURL) 
				$api_url = str_replace('https://','http://',MDWORKS_API_URL);
			else
				$api_url = MDWORKS_API_URL;

			$client = new soapclient($api_url); // 'https://www.eml-srv.com/_soap/control.php');
			//$parametres = array( 'login'=>$config['login'], 'motdepasse'=>$config['motdepasse'], 'type'=>'NPAI', 'periode'=>'86000' );
			//$variable=$client->call('Extrait_Periode', $parametres);

			if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
				echo '<fieldset><legend>$client,$action,$parametres</legend><pre>';
				var_dump($client,$action,$parametres);
				echo '</pre></fieldset>';
			}
			logMDworks( var_export($client,true) );
			logMDworks( var_export($action,true) );
			logMDworks( var_export($parametres,true) );

			$variable = $client ? $client->call($action, $parametres) : false;

			if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
				echo '<fieldset><legend>$variable</legend><pre>';
				var_dump($variable);
				echo '</pre></fieldset>';
			}
			//logMDworks( var_export($variable,true) );

			// Récupérer l'erreur le cas échéant 
			if($client->fault) {
				$message = "SOAP Fault: (faultcode: {$client->faultcode}, faultstring: {$client->faultstring}, actor: {$client->faultactor})";
				if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
					echo '<fieldset><legend>ERREUR!</legend><pre>';
					echo $message;
					echo '</pre></fieldset>';
				}
				trigger_error($message, E_USER_ERROR);
				logMDworks( $message );
				return false;	
			}
			return $variable;

		} else {
			$message = "SOAP Fault: (faultcode: 404, faultstring: SOAP not installed, actor: ".basename(__FILE__).")";
			if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
				echo '<fieldset><legend>ERREUR!</legend><pre>';
				echo $message;
				echo '</pre></fieldset>';
			}
			trigger_error($message, E_USER_ERROR);
			logMDworks( $message );
			return false;
		}
	}



	/**
	 * Lance une commande REST
	 * @param string $url
	 * @param array $headers
	 * @param string $username
	 * @param string $password
	 * @param string $method
	 * @param array $data
	 * @param object $response
	 * @return int
	 */
	function mdworksApiCallREST($url,$headers,$username,$password,$method,&$data,&$response) {
		logMDworks('mdworksApiCallREST!');
		$handle = curl_init();
		curl_setopt($handle, CURLOPT_URL, $url);
		curl_setopt($handle, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($handle, CURLOPT_USERPWD, $username . ":" . $password);

		switch(strtoupper($method))
		{

			case 'GET':
				// rien à faire de plus...
			break;

			case 'POST':
				curl_setopt($handle, CURLOPT_POST, true);
				curl_setopt($handle, CURLOPT_POSTFIELDS, $data);
			break;

			case 'PUT':
				curl_setopt($handle, CURLOPT_CUSTOMREQUEST, 'PUT');
				curl_setopt($handle, CURLOPT_POSTFIELDS, $data);
			break;

			case 'DELETE':
				curl_setopt($handle, CURLOPT_CUSTOMREQUEST, 'DELETE');
			break;

			default:
				trigger_error('Méthode non implémentée');
				$response = null;
				return false;
		}

		$response = curl_exec($handle);
		$code = curl_getinfo($handle, CURLINFO_HTTP_CODE);

		if(error_reporting()==E_ALL) var_dump($response, '<hr>',$code);

		return $code;
	}

	function codeSortieApiREST($code) {
		logMDworks('codeSortieApiREST!');
		$codes_erreur = array(
			'100' => 'Continue',
			'200' => 'OK',
			'201' => 'Created',
			'202' => 'Accepted',
			'203' => 'Non-Authoritative Information',
			'204' => 'No Content',
			'205' => 'Reset Content',
			'206' => 'Partial Content',
			'300' => 'Multiple Choices',
			'301' => 'Moved Permanently',
			'302' => 'Found',
			'303' => 'See Other',
			'304' => 'Not Modified',
			'305' => 'Use Proxy',
			'307' => 'Temporary Redirect',
			'400' => 'Bad Request',
			'401' => 'Unauthorized',
			'402' => 'Payment Required',
			'403' => 'Forbidden',
			'404' => 'Not Found',
			'405' => 'Method Not Allowed',
			'406' => 'Not Acceptable',
			'409' => 'Conflict',
			'410' => 'Gone',
			'411' => 'Length Required',
			'412' => 'Precondition Failed',
			'413' => 'Request Entity Too Large',
			'414' => 'Request-URI Too Long',
			'415' => 'Unsupported Media Type',
			'416' => 'Requested Range Not Satisfiable',
			'417' => 'Expectation Failed',
			'500' => 'Internal Server Error',
			'501' => 'Not Implemented',
			'503' => 'Service Unavailable',
		);
		return $code_erreur[$code];
	}

	/**
	 * Retourne la période depuis la dernière mise à jour
	 * @return int
	 */
	function recherchePeriode() {
		logMDworks('recherchePeriode!');
		global $wpdb;
		$periode_en_secondes = MDWORKS_MAX_PERIOD * 24*3600;
		if ($wpdb->query("	SELECT MAX(`npai_date`) as dt FROM `contacts` WHERE `npai_date` IS NOT NULL 
							UNION
							SELECT MAX(`desinscrit_date`) as dt FROM `contacts` WHERE `desinscrit_date` IS NOT NULL
							ORDER BY dt ")) {
			if ('0000-00-00'==$wpdb->last_result[0]->dt) {
				$timestamp = strtotime($wpdb->last_result[0]->dt);
				$periode_en_secondes = time() - $timestamp;
			}
		}
		logMDworks( $periode_en_secondes );
		return min(1*$periode_en_secondes , MDWORKS_MAX_PERIOD *24*3600);
	}

	/**
	 * Retourne des infos sur le compte MDworks (ça permet de savoir si le SOAP est bien configuré)
	 * @return string
	 */
	function infosMDworks() {
		logMDworks('infosMDworks!');
		if (!defined('MDWORKS_API_LOGIN') || ''.MDWORKS_API_LOGIN == '') return "Mauvaise configuration MDworks";
		$credits = mdworksApiCall('Recup_Credit', array());
		$campagnes = mdworksApiCall('Liste_Campagnes_API', array());
		ob_start();
		detectMDworksInstall();
		echo number_format($credits,0,'.',' ').' crédit(s)<br>';
		if (is_array($campagnes)) 
			echo number_format(count($campagnes),0,'.',' ').' campagne(s)<br>';
		else {
			echo '<pre>'; print_r($campagnes); echo '</pre>';	
		}
		
		return ob_get_clean();
	}

	/**
	 * Met à jour la table "Contacts" pour tous les N.P.A.I (retourne le nombre de npai)
	 * @param int $periode_en_secondes 
	 * @return int
	 */
	function majTousNpai($periode_en_secondes=false) {
		logMDworks('majTousNpai!');
		global $wpdb,$success; $success = 0;
		if (empty($wpdb)) return 0;
		if (!defined('MDWORKS_API_LOGIN') || ''.MDWORKS_API_LOGIN == '') return 0;

		if (false===$periode_en_secondes) $periode_en_secondes=recherchePeriode();
		$now = time()-1*$periode_en_secondes;
		$date = date(MDWORKS_DATE_FORMAT,$now);
		if (0===$periode_en_secondes) $periode_en_secondes = MDWORKS_MAX_PERIOD * 24*3600;
		$emails = mdworksApiCall('Extrait_Periode', array( 'type'=>'NPAI', 'periode'=>''.min(1*$periode_en_secondes, MDWORKS_MAX_PERIOD * 24*3600) ));
		if (false===$emails || !is_array($emails)) return 0;
		
		for($i=0,$n=count($emails); $i<$n; $i++) {
			$res = $wpdb->query( $wpdb->prepare("UPDATE contacts SET npai=1, npai_date=%s WHERE mail=%s ",$date,$emails[$i]) );
			if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
				echo '<fieldset><legend>SQL</legend><pre>';
				echo $wpdb->last_query, ' : ', false!==$res ? $wpdb->rows_affected : $wpdb->last_error;
				echo '</pre></fieldset>';
			}
			logMDworks( "{$wpdb->last_query} : ".( false!==$res ? $wpdb->rows_affected : $wpdb->last_error ) );
			if (false!==$res && $wpdb->rows_affected) $success++;
		}
		$emails=count($emails);
		logMDworks( "success = $success vs emails = $emails" );
		return $emails;
	}

	/**
	 * Met à jour la table "Contacts" pour tous les désinscrits (retourne le nombre de désinscrits)
	 * @param int $periode_en_secondes 
	 * @return int
	 */
	function majTousDesinscrits($periode_en_secondes=false) {
		logMDworks('majTousDesinscrits!');
		global $wpdb,$success; $success = 0;
		if (empty($wpdb)) return 0;
		if (!defined('MDWORKS_API_LOGIN') || ''.MDWORKS_API_LOGIN == '') return 0;

		if (false===$periode_en_secondes) $periode_en_secondes=recherchePeriode();
		$now = time()-1*$periode_en_secondes;
		$date = date(MDWORKS_DATE_FORMAT,$now);
		if (0===$periode_en_secondes) $periode_en_secondes = MDWORKS_MAX_PERIOD * 24*3600;
		$emails = mdworksApiCall('Extrait_Periode', array( 'type'=>'desinscrits', 'periode'=>''.min(1*$periode_en_secondes, MDWORKS_MAX_PERIOD * 24*3600) ));
		if (false===$emails || !is_array($emails)) return 0;
		
		for($i=0,$n=count($emails); $i<$n; $i++) {
			$res = $wpdb->query( $wpdb->prepare("UPDATE contacts SET desinscrit=1, desinscrit_date=%s WHERE mail=%s ",$date,$emails[$i]) );
			if (defined('SOAP_DEBUG') && SOAP_DEBUG) {
				echo '<fieldset><legend>SQL</legend><pre>';
				echo $wpdb->last_query, ' : ', false!==$res ? $wpdb->rows_affected : $wpdb->last_error;
				echo '</pre></fieldset>';
			}
			logMDworks( "{$wpdb->last_query} : ".( false!==$res ? $wpdb->rows_affected : $wpdb->last_error ) );
			if (false!==$res && $wpdb->rows_affected) $success++;
		}
		$emails=count($emails);
		logMDworks( "success = $success vs emails = $emails" );
		return $emails;
	}

}